function test_suite = testCross %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
p = polysym.empty;
q = polysym.empty;
f = @() cross(p,q);
assertExceptionThrown(f,'polysym:cross:InvalidDimAorB')

function testNotSameSize
p = polysym(zeros(3,1));
q = p.';
f = @() cross(p,q);
assertExceptionThrown(f,'polysym:cross:InputSizeMismatch')

function testRowVectors
x = polysym('x',[1 3]);
y = polysym('y',[1 3]);
assertEqual(cross(x,y),[x(2)*y(3)-x(3)*y(2) x(3)*y(1)-x(1)*y(3) x(1)*y(2)-x(2)*y(1)])

function testZeroComponent
% Note the parentheses around (x(2)*y(1)). This forces evaluation using
% uminus; otherwise, the result is (-x2)*y1.
x = polysym('x',[1 3]);
y = polysym('y',[1 3]);
x(1) = 0;
assertEqual(cross(x,y),[x(2)*y(3)-x(3)*y(2) x(3)*y(1) -(x(2)*y(1))])

function testColumnVectors
x = polysym('x',[3 1]);
y = polysym('y',[3 1]);
assertEqual(cross(x,y),[x(2)*y(3)-x(3)*y(2); x(3)*y(1)-x(1)*y(3); x(1)*y(2)-x(2)*y(1)])

function testMatrices
x = polysym([0 0 1; 0 0 1; 0 0 1]);
y = polysym('y',3);
M = polysym(zeros(3));
M(:,3) = y([3 1 2],3)-y([2 3 1],3);
assertEqual(cross(x,y),M)

function testMatricesSecondDim
x = polysym([0 0 1; 0 0 1; 0 0 1]);
y = polysym('y',3);
M = polysym(zeros(3));
M(:,1) = -y(:,2);
M(:,2) = y(:,1);
assertEqual(cross(x,y,2),M)
